<?php 
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    
    if(isset($_GET["id"])) {
        $elemento = $geecomDb->leggiSingolaRiga("geec_elementiForm",filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        $datiOccorrenza = $geecomDb->leggiSingolaRiga("geec_form",$elemento["idForm"]);
    }
    
    $arrayDimensioniIcona = array("fa-2x"=>"2x","fa-3x"=>"3x","fa-5x"=>"5x","fa-7x"=>"7x","fa-10x"=>"10x");
    $arrayColori          = array("Primary","Secondary","Info","Light","Dark","Warning","Danger");
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom Doc - Creazione elemento</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>
	
        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">

                <?php 
                    if(isset($_GET["status"])) {
                        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
                    }
                    else {
                        $status = 0;
                    }

                ?>
                    <div class="row py-4">
                        <?php 
                            if($status==200) {
                                echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento modificato
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==210) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento duplicato, modificalo per non avere due elementi uguali
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                        ?>
                        
                        <div class="col-12">
                            <div class="form-row justify-content-between mb-3">
                                <div class="col-auto d-flex">
                                    <nav aria-label="breadcrumb" class="align-self-center">
                                        <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                            <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                            <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                            <li class="breadcrumb-item"><a href="index.php">Form</a></li>
                                            <li class="breadcrumb-item"><a href="creaForm.php?id=<?php echo $datiOccorrenza["id"] ?>"><?php echo $datiOccorrenza["nome"] ?></a></li>
                                            <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($elemento)? $elemento["nome"] : "Nuova campagna"))?></li>
                                        </ol>
                                    </nav>
                                </div>
                                <div class="col-auto text-right">
                                    <a class="btn btn-outline-primary" href="creaForm.php?id=<?php echo $datiOccorrenza["id"] ?>&status=100"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                    <button class="btn btn-primary" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                    <button type="button" class="btn btn-warning mt-2 mt-lg-0" onclick="location.href='controller/controllerComponente.php?id=1&idElemento=<?php echo $elemento["id"] ?>&operazione=duplicaElemento';"><i class="far fa-clone mr-2"></i>Duplica</button>
                                </div>
                            </div>
                            <div class="card mb-4 box-shadow-lite">
                                <form name="formComponente" action="controller/controllerComponente.php" method="post">
                                    
                                    <input type="text" class="d-none" name="operazione" value="modificaElemento">
                                    <input type="text" class="d-none" name="id" value="<?php echo((isset($elemento) ? $elemento["idForm"] : "0")); ?>">
                                    <input type="text" class="d-none" name="idElemento" value="<?php echo((isset($elemento) ? $elemento["id"] : "0")); ?>">

                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <div class="row">
                                                    <div class="form-group col-md-3">
                                                        <label>Elemento</label>
                                                        <input type="text" class="form-control" id="nomeElemento" name="nome" aria-describedby="etichetta" value="<?php echo((isset($elemento) ? $elemento["nome"] : "")) ?>" placeholder="Etichetta" onchange="aggiornaValoreEtichetta()">
                                                    </div>
                                                    
                                                    <div class="col-md-3 form-group">
                                                        <label>Spazio occupato</label>
                                                        <select class="form-control" name="spazioOccupato">
                                                        <?php 
                                                            $arrayDimensioniColonna = ["col-12"=>"intera riga","col-lg-10"=>"5/6 della riga","col-lg-8"=>"2/3 della riga", "col-md-6"=>"1/2 della riga","col-md-4"=>"1/3 della riga","col-md-6 col-lg-3"=>"1/4 della riga","d-none"=>"nascosto"];
                                                            foreach($arrayDimensioniColonna as $classe=>$descrizione) {
                                                                if(isset($elemento) && $elemento["spazioOccupato"]==$classe) {
                                                                    echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                                }
                                                                else {
                                                                    echo"<option value=\"$classe\">$descrizione</option>";
                                                                }
                                                            }
                                                        ?>
                                                        </select>
                                                        <small class="text-muted">Lo spazio orizzontale occupato dall'elemento</small>
                                                    </div>
                                                    
                                                    <div class="form-group col-md-3">
                                                        <label for="titolo-articolo">Tipo elemento</label>
                                                        <select name="tipo" id="tipoElemento" class="form-control" onchange="aggiornaCampiOpzionali()">
                                                            <?php 
                                                                $tipiCampo = array("Testo","Email","Checkbox","Tendina","Area testo","Data","Orario");
                                                                foreach($tipiCampo as $tipo) {
                                                                    if($elemento["tipo"]==$tipo) {
                                                                        echo"<option value=\"$tipo\" selected>$tipo</option>";
                                                                    }
                                                                    else {                                                                    
                                                                        echo"<option value=\"$tipo\">$tipo</option>";
                                                                    }
                                                                }
                                                            ?>
                                                        </select>
                                                        <small class="text-muted">Seleziona il tipo di elemento</small>
                                                    </div>
                                                    
                                                    <div class="col-md-3 form-group">
                                                        <label for="select1" class="d-inline mr-3 d-block">Obbligatorio </label>
                                                        <input type="checkbox" name=obbligatorio class="js-switch" value="si" <?php
                                                              if($elemento["obbligatorio"]=="si") { // se il valore = si aggiunge la parola checked
                                                                echo"CHECKED";
                                                             }
                                                          ?> />
                                                        <small class="text-muted d-block">Rendi il campo obbligatorio</small>
                                                    </div>
                                                    
                                                    <div class="w-100"></div>
                                                    
                                                    <div class="form-group col-md-3">
                                                        <label for="titolo-articolo">Etichetta</label>
                                                        <input type="text" class="form-control" id="etichettaElemento" name="etichetta" value="<?php echo $elemento["etichetta"] ?>">
                                                        <small class="text-muted">Identifica il campo input</small>
                                                    </div>
                                                    
                                                    <div class="form-group col-md-3">
                                                        <label for="titolo-articolo">Valore</label>
                                                        <input type="text" class="form-control" name="valore" value="<?php echo $elemento["valore"] ?>">
                                                        <small class="text-muted">Il valore di default del campo input</small>
                                                    </div>
                                                    
                                                    <div id="divPlaceholder" class="form-group col-md-3">
                                                        <label for="titolo-articolo">Placeholder</label>
                                                        <input type="text" class="form-control" id="placeholder" name="placeholder" value="<?php echo $elemento["placeholder"] ?>">
                                                        <small class="text-muted">Il placeholder viene mostrato quando il campo è vuoto</small>
                                                    </div>

                                                    <div id="divOpzioniElemento" class="<?php echo (($elemento["tipo"]=="Tendina") ? "form-group col-md-4" : "d-none") ?>">
                                                        <label for="titolo-articolo">Opzioni</label>
                                                        <textarea class="form-control" name="opzioni"><?php echo $elemento["opzioni"] ?></textarea>
                                                        <small class="text-muted">Scrivi le opzioni della tendina separate da una virgola</small>
                                                    </div>
                                                </div>   
                                            </div><!--/Colonna principale -->
                                        </form>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <button type="button" class="btn btn-primary float-right" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                    </div>
                                </div>
                            </div>
                        
                            </div>
                        </div>
           
                    </form>
                </div>
            </div>
        </main>

        <?php 
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../include/jsBaseComponenti.php";
        ?>
        
        <!-- Dropzone -->
        <script type="text/javascript" src="../../../plugins/dropzone/dropzone.js"></script>
        <script>
            $("#frmFileUpload-00").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineElemento").src=response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaImmagineElemento",
                    idElemento:<?php echo $elemento["id"] ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
            
            function aggiornaCampiOpzionali() {
                var tipoElemento = document.getElementById("tipoElemento").value;
                if(tipoElemento=="Tendina") {
                    document.getElementById("divOpzioniElemento").className = "form-group col-md-4";
                    document.getElementById("divPlaceholder").className = "d-none";
                }
                else {
                    document.getElementById("divOpzioniElemento").className = "d-none";
                    document.getElementById("divPlaceholder").className = "form-group col-md-4";
                }
            }
            
            function aggiornaValoreEtichetta() {
                var nomeElemento      = document.getElementById("nomeElemento").value;
                var etichettaElemento = document.getElementById("etichettaElemento").value;
                var placeholder       = document.getElementById("placeholder").value;
                
                if(etichettaElemento=="") {
                    document.getElementById("etichettaElemento").value = nomeElemento;
                }
                
                if(placeholder=="") {
                    document.getElementById("placeholder").value = nomeElemento;
                }
            }
        </script>

    </body>
</html>
